/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.jnireg;

import ibm.nways.jdm.jnireg.RegValue;
import ibm.nways.jdm.jnireg.RegistryException;

public class RegKey {
    public static final int KEYOPEN_READ = 0;
    public static final int KEYOPEN_WRITE = 1;
    public static final int KEYOPEN_ALL_ACCESS = 2;
    public static final int KEYOPEN_CREATE_SUB_KEY = 3;
    public static final int HKEY_CLASSES_ROOT = 1;
    public static final int HKEY_CURRENT_CONFIG = 2;
    public static final int HKEY_CURRENT_USER = 3;
    public static final int HKEY_LOCAL_MACHINE = 4;
    public static final int HKEY_USERS = 5;
    private int key;
    private boolean openKey = false;
    private String keyStr;

    public RegKey(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                this.newRoot(this.classesRoot(), "HKCR");
                return;
            }
            case 2: {
                this.newRoot(this.currentConfig(), "HKCC");
                return;
            }
            case 3: {
                this.newRoot(this.currentUser(), "HKCU");
                return;
            }
            case 4: {
                this.newRoot(this.localMachine(), "HKLM");
                return;
            }
            case 5: {
                this.newRoot(this.users(), "HKUS");
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public RegKey(RegKey regKey, String string, int n) throws RegistryException {
        this(regKey, string, n, false);
    }

    public RegKey(RegKey regKey, String string, int n, boolean bl) throws RegistryException {
        int[] nArray = new int[1];
        int n2 = this.regOpenKey(regKey.key, string, n, nArray, bl);
        if (n2 != 0) {
            throw new RegistryException("regOpenKey rc is " + n2);
        }
        this.key = nArray[0];
        this.keyStr = String.valueOf(regKey.keyStr) + "\\" + string;
        this.openKey = true;
    }

    public void closeKey() throws RegistryException {
        if (this.openKey) {
            int n = this.regCloseKey(this.key);
            if (n != 0) {
                throw new RegistryException("regCloseKey rc is " + n);
            }
            this.openKey = false;
        }
    }

    public native String enumKey(int var1) throws RegistryException;

    public native void deleteKey(String var1) throws RegistryException;

    public native RegValue enumValue(int var1) throws RegistryException;

    public native RegValue getValue(String var1) throws RegistryException;

    public native void deleteValue(String var1) throws RegistryException;

    public native void setValue(String var1, String var2) throws RegistryException;

    public native void setValue(String var1, int var2) throws RegistryException;

    public native void setValue(String var1, byte[] var2) throws RegistryException;

    public String toString() {
        return "RegKey[key: " + this.key + " name: " + this.keyStr + " open: " + this.openKey + "]";
    }

    private native int regOpenKey(int var1, String var2, int var3, int[] var4, boolean var5) throws RegistryException;

    private native int regCloseKey(int var1);

    private native int classesRoot();

    private native int currentConfig();

    private native int currentUser();

    private native int localMachine();

    private native int users();

    private void newRoot(int n, String string) {
        this.key = n;
        this.keyStr = string;
    }

    public void finalize() {
        try {
            this.closeKey();
            return;
        }
        catch (RegistryException registryException) {
            return;
        }
    }

    static {
        System.loadLibrary("jnireg");
    }
}

